(function() {
  // ビジュアルエディタにプルダウンメニューの追加
	tinymce.PluginManager.add('my_mce_button', function( editor, url ) {
		editor.addButton( 'my_mce_button', {
			text: 'クイックタグ',
			icon: false,
			type: 'menubutton',
			menu: [
				{
							text: 'セクションヘッダ画像',
							onclick: function() {
								editor.insertContent('<img class="section_image" src="ここに表示させたい画像URL" alt="" />');
							}
				},
				{
							text: 'H2見出し',
							onclick: function() {
								editor.insertContent('<h2>H2見出し</h2>');
							}
				},
				{
							text: 'H3見出し',
							onclick: function() {
								editor.insertContent('<h3>H3見出し</h3>');
							}
				},
				{
							text: 'H4見出し',
							onclick: function() {
								editor.insertContent('<h4>H4見出し</h4>');
							}
				},
				{
							text: 'H5見出し',
							onclick: function() {
								editor.insertContent('<h5>H5見出し</h5>');
							}
				},
				{
							text: '区切り線',
							onclick: function() {
								editor.insertContent('<hr>');
							}
				},
				{
							text: 'テキスト（強調）',
							onclick: function() {
								editor.insertContent('<p class="read">任意のテキスト</p>');
							}
				},
				{
							text: 'テキスト（標準）',
							onclick: function() {
								editor.insertContent('<p class="text">任意のテキスト</p>');
							}
				},
				{
							text: 'テキスト（補足）',
							onclick: function() {
								editor.insertContent('<p class="note">任意のテキスト</p>');
							}
				},
				{
							text: '装飾（強調）',
							onclick: function() {
								editor.insertContent('<strong>任意のテキスト</strong>');
							}
				},
				{
							text: 'リスト',
							onclick: function() {
								editor.insertContent('<ul class="list"><li>任意のテキスト</li><li>任意のテキスト</li><li>任意のテキスト</li></ul>');
							}
				},
				{
							text: 'テーブル（標準）',
							onclick: function() {
								editor.insertContent('<table class="tbl"><thead><tr><th>ヘッダ</th><th>ヘッダ</th></tr></thead><tbody><tr><td>データ</td><td>データ</td></tr></tbody></table>');
							}
				},
				{
							text: 'テーブル（スクロール）',
							onclick: function() {
								editor.insertContent('<div class="wrap_tbl"><table class="tbl"><thead><tr><th>ヘッダ</th><th>ヘッダ</th></tr></thead><tbody><tr><td>データ</td><td>データ</td></tr></tbody></table></div>');
							}
				},
				{
							text: 'ボタン（特別）',
							onclick: function() {
								editor.insertContent('<a class="special_btn" href="#">ボタン（特別）</a>');
							}
				},
				{
							text: 'ボタン（標準）',
							onclick: function() {
								editor.insertContent('<a class="btn" href="#">ボタン（特別）</a>');
							}
				},
				{
							text: 'ボタン（矢印つき）',
							onclick: function() {
								editor.insertContent('<a class="btn btn_arrow" href="#">ボタン（矢印つき）</a>');
							}
				},
				{
							text: 'ボタン（リスト）',
							onclick: function() {
								editor.insertContent('<ul class="wrap_btn"><li><a class="btn" href="#">ボタン</a></li><li><a class="btn" href="#">ボタン</a></li></ul>');
							}
				},
				{
							text: '画像つきテキスト',
							onclick: function() {
								editor.insertContent('<div class="wrap"><img class="image" src="ここに表示させたい画像URL" alt="" /><div class="text">任意のテキスト</div></div>');
							}
				}
			]
		});
	});
})();